# import libraries
import numpy as np
from matplotlib import pyplot as plt

# Loading results files
dirdyn_Pz          = np.loadtxt("resultsR/dirdyn_Pz.res")
dirdyn_Pz [:,1]    -= 0.278
dirdyn_Vz          = np.loadtxt("resultsR/dirdyn_Vz.res")
dirdyn_Az          = np.loadtxt("resultsR/dirdyn_Az.res")

# plotting
f, axarr = plt.subplots(3, sharex=True, num='C')

axarr[0].set_title("Vertical displacement of the wheel centre")
axarr[0].set_ylabel('vertical deflection [m]')
axarr[0].plot(dirdyn_Pz[:,0], dirdyn_Pz[:,1])
axarr[0].set_ylim(-0.160,0.0)

axarr[1].set_title("Vertical velocity of the wheel centre")
axarr[1].set_ylabel('vertical velocity [m/s]')
axarr[1].plot(dirdyn_Vz[:,0], dirdyn_Vz[:,1])
axarr[1].set_ylim(-5.,4.)

axarr[2].set_title("Vertical acceleration of the wheel centre")
axarr[2].set_ylabel('vertical acceleration [m/s$^{2}$]')
axarr[2].set_xlabel('time [s]')
axarr[2].plot(dirdyn_Az[:,0], dirdyn_Az[:,1])
axarr[2].set_ylim(-200,250)


plt.subplots_adjust(left=0.15, bottom=0.07, right=0.85, top=0.96, wspace=None, hspace=0.20)

plt.xlim(0.,1.)
#plt.title("Results Five-Link Suspension")
plt.show()
